unit Plane;
{Demonstrates 2-d-graphing with TMathImage. I've set all the real types
here to double to demonstrate that TMathImage can be used with any float
type. Parts that make use of TMathImage are marked ***********}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Mathimge;

type
  TPlaneGraphs = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    F1line: TEdit;
    F2line: TEdit;
    Button2: TButton;
    Label3: TLabel;
    Meshline: TEdit;
    ColorDialog1: TColorDialog;
    Periods: TLabel;
    Pline: TEdit;
    CheckBox1: TCheckBox;
    Panel2: TPanel;
    xshow: TLabel;
    yshow: TLabel;
    GraphImage: tMathImage;
    x1edit: TEdit;
    x2edit: TEdit;
    y1edit: TEdit;
    y2edit: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure GraphImageMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure F1lineChange(Sender: TObject);
    procedure F2lineChange(Sender: TObject);
    procedure PlineChange(Sender: TObject);
    procedure MeshlineChange(Sender: TObject);
  private
    graphcolor:longint;
    f1,f2,p:double;
    mesh:integer;
    function getf1:double;
    function getf2:double;
    function getp:double;
    function getmesh:integer;
    function r(o:double):double;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PlaneGraphs: TPlaneGraphs;

implementation

{$R *.DFM}

function TPlaneGraphs.getf1;
var x:double; c:integer;
begin
  val(f1line.text,x,c);
  if c=0 then getf1:=x;
end;

function TPlaneGraphs.getf2;
var x:double; c:integer;
begin
  val(f2line.text,x,c);
  if c=0 then getf2:=x;
end;

function TPlaneGraphs.getp;
var x:double; c:integer;
begin
  val(pline.text,x,c);
  if c=0 then getp:=x;
end;

function TPlaneGraphs.getmesh;
var i,c:integer;
begin
  val(meshline.text,i,c);
  if c=0 then getmesh:=i;
end;

function TPlaneGraphs.r;
begin
  r:=sin(o*f1)+cos(o*f2);
end;


procedure TPlaneGraphs.Button2Click(Sender: TObject);
begin
  with colordialog1 do
  if execute then graphcolor:=color;
end;

{**************************************}
procedure TPlaneGraphs.Button1Click(Sender: TObject);
var i:integer; o:double;
begin
  with graphimage do
  begin
    setworld(strtofloat(x1edit.text),strtofloat(y1edit.text),
             strtofloat(x2edit.text),strtofloat(y2edit.text));
    clear;
    setcolor(graphcolor);
    if checkbox1.checked then
    begin
      canvas.font.name:='Arial';
      canvas.font.size:=9;
      canvas.font.style:=[fsitalic,fsbold];
      d2axes:=true;
    end else d2axes:=false;
    movetopoint(r(0),0);
    for i:=1 to mesh do
    begin
      o:=i*2*p*Pi/mesh;
      drawlineto(r(o)*cos(o),r(o)*sin(o));
    end;
    if checkbox1.checked then
    drawaxes('x','y',true,clblack,clred);
  end;
end;

{************************************}
procedure TPlaneGraphs.FormResize(Sender: TObject);
begin
  graphimage.reset;
  button1click(self);
end;

{****************************************}
procedure TPlaneGraphs.GraphImageMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  with GraphImage do
  begin
    xshow.caption:=floattostrf(worldx(x),ffgeneral,5,5);
    yshow.caption:=floattostrf(worldy(y),ffgeneral,5,5);
  end;
end;

{************************}
procedure TPlaneGraphs.FormCreate(Sender: TObject);
begin
  with graphimage do
  begin
    d2worldx1:=-1; d2worldx2:=1;
    d2worldy1:=-1; d2worldy2:=1;
    d2axes:=false;
    graphcolor:=clolive;
    f1:=getf1; f2:=getf2; p:=getp; mesh:=getmesh;
  end;
end;

procedure TPlaneGraphs.F1lineChange(Sender: TObject);
begin
  f1:=getf1;
end;

procedure TPlaneGraphs.F2lineChange(Sender: TObject);
begin
  f2:=getf2;
end;

procedure TPlaneGraphs.PlineChange(Sender: TObject);
begin
  p:=getp;
end;

procedure TPlaneGraphs.MeshlineChange(Sender: TObject);
begin
  mesh:=getmesh;
end;



end.
